data:extend(
{
    {
    type = "item",
    name = "omni-plant",
    icon = "__omnimatter_crystal__/graphics/icons/omni-plant.png",
	flags = {"goes-to-quickbar"},
    subgroup = "crystallization",
    order = "a[burner-omnitractor]",
    place_result = "omni-plant",
    stack_size = 5,
    },
	{
    type = "assembling-machine",
    name = "omni-plant",
    icon = "__omnimatter_crystal__/graphics/icons/omni-plant.png",
	flags = {"placeable-neutral","player-creation"},
    minable = {mining_time = 1, result = "omni-plant"},
	fast_replaceable_group = "omni-plants",
    max_health = 300,
	corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-2.4, -2.4}, {2.4, 2.4}},
    selection_box = {{-2.7, -2.7}, {2.7, 2.7}},
	fluid_boxes =
    {
      {
        production_type = "input",
        --pipe_picture = assembler3pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {-3, 0} }}
      },
      {
        production_type = "input",
        --pipe_picture = assembler3pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {3, 0} }}
      },
	  {
        production_type = "output",
        --pipe_picture = assembler3pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = 2,
        pipe_connections = {{ type="output", position = {0, -3} }}
      },
	  {
        production_type = "output",
        --pipe_picture = assembler3pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = 2,
        pipe_connections = {{ type="output", position = {0, 3} }}
      },
    },
	module_specification =
    {
      module_slots = i
    },
    allowed_effects = {"consumption", "speed", "pollution", "productivity"},
    crafting_categories = {"omniplant"},
    crafting_speed = 1,
	source_inventory_size = 3,
	energy_source =
    {
	  type = "electric",
	  usage_priority = "secondary-input",
	  emissions = 0.04 / 3.5
	},
    energy_usage = "250kW",
    ingredient_count = 4,
    animation ={
	layers={
	{
        filename = "__omnimatter_crystal__/graphics/buildings/omni-plant.png",
		priority = "extra-high",
        width = 224,
        height = 224,
        frame_count = 36,
		line_length = 6,
        shift = {0.00, -0.05},
		scale = 1,
		animation_speed = 0.5
	},
	}
	},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__omnimatter__/sound/ore-crusher.ogg", volume = 0.8 },
	  idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 2,
    },
    },
}
  )